/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster;

import it.quizmaster.model.BancaDatiNazioni;
import it.quizmaster.model.Domanda;
import it.quizmaster.model.GestoreDati;
import it.quizmaster.model.Giocatore;
import it.quizmaster.model.SessioneQuiz;
import it.quizmaster.view.SchermataClassifica;
import it.quizmaster.view.SchermataLogin;
import it.quizmaster.view.SchermataMenu;
import it.quizmaster.view.SchermataQuiz;
import it.quizmaster.view.SchermataRisultati;
import it.quizmaster.view.SchermataStatistiche;
import java.util.List;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class App
extends Application {
    private Stage stage;
    private GestoreDati gestoreDati;
    private Giocatore giocatoreCorrente;
    public static final int DOMANDE_PER_QUIZ = 10;
    public static final int TEMPO_LIMITE_SECONDI = 15;
    public static final int PUNTI_BASE = 1000;

    public void start(Stage primaryStage) {
        this.stage = primaryStage;
        this.gestoreDati = new GestoreDati();
        this.stage.setTitle("\ud83c\udf0d QuizMaster - Quiz sulle Bandiere");
        this.stage.setMinWidth(900.0);
        this.stage.setMinHeight(650.0);
        this.stage.setWidth(960.0);
        this.stage.setHeight(700.0);
        this.stage.setResizable(true);
        this.mostraLogin();
        this.stage.show();
    }

    public void mostraLogin() {
        SchermataLogin login = new SchermataLogin(this);
        this.impostaScena(login.crea());
    }

    public void mostraMenu() {
        SchermataMenu menu = new SchermataMenu(this);
        this.impostaScena(menu.crea());
    }

    public void mostraQuiz() {
        List<Domanda> domande = BancaDatiNazioni.generaDomande(10, 15, 1000);
        SessioneQuiz sessione = new SessioneQuiz(domande);
        SchermataQuiz quiz = new SchermataQuiz(this, sessione);
        this.impostaScena(quiz.crea());
    }

    public void mostraRisultati(SessioneQuiz sessione) {
        SchermataRisultati risultati = new SchermataRisultati(this, sessione);
        this.impostaScena(risultati.crea());
    }

    public void mostraStatistiche() {
        SchermataStatistiche statistiche = new SchermataStatistiche(this);
        this.impostaScena(statistiche.crea());
    }

    public void mostraClassifica() {
        SchermataClassifica classifica = new SchermataClassifica(this);
        this.impostaScena(classifica.crea());
    }

    private void impostaScena(StackPane root) {
        root.getStyleClass().add((Object)"main-bg");
        Scene scena = new Scene((Parent)root);
        scena.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("style.css").toExternalForm());
        this.stage.setScene(scena);
    }

    public GestoreDati getGestoreDati() {
        return this.gestoreDati;
    }

    public Giocatore getGiocatoreCorrente() {
        return this.giocatoreCorrente;
    }

    public void setGiocatoreCorrente(Giocatore giocatore) {
        this.giocatoreCorrente = giocatore;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void stop() {
        if (this.gestoreDati != null) {
            this.gestoreDati.salvaDati();
        }
    }

    public static void main(String[] args) {
        App.launch((String[])args);
    }
}

