/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.model;

import it.quizmaster.model.Domanda;
import it.quizmaster.model.Nazione;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class BancaDatiNazioni {
    private static final List<Nazione> NAZIONI = new ArrayList<Nazione>();

    public static List<Nazione> getTutteLeNazioni() {
        return Collections.unmodifiableList(NAZIONI);
    }

    public static List<Domanda> generaDomande(int numeroDomande, int tempoLimite, int puntiBase) {
        ArrayList<Domanda> domande = new ArrayList<Domanda>();
        ArrayList<Nazione> pool = new ArrayList<Nazione>(NAZIONI);
        Collections.shuffle(pool);
        int max = Math.min(numeroDomande, pool.size());
        Random random = new Random();
        for (int i = 0; i < max; ++i) {
            Nazione corretta = (Nazione)pool.get(i);
            ArrayList<Nazione> opzioniSbagliate = new ArrayList<Nazione>();
            ArrayList<Nazione> altreNazioni = new ArrayList<Nazione>(NAZIONI);
            altreNazioni.remove(corretta);
            Collections.shuffle(altreNazioni);
            for (int j = 0; j < 3 && j < altreNazioni.size(); ++j) {
                opzioniSbagliate.add((Nazione)altreNazioni.get(j));
            }
            ArrayList<Nazione> opzioni = new ArrayList<Nazione>(opzioniSbagliate);
            int posizioneCorretta = random.nextInt(4);
            opzioni.add(posizioneCorretta, corretta);
            domande.add(new Domanda(corretta, opzioni, tempoLimite, puntiBase));
        }
        return domande;
    }

    static {
        NAZIONI.add(new Nazione("Italia", "it"));
        NAZIONI.add(new Nazione("Francia", "fr"));
        NAZIONI.add(new Nazione("Germania", "de"));
        NAZIONI.add(new Nazione("Spagna", "es"));
        NAZIONI.add(new Nazione("Portogallo", "pt"));
        NAZIONI.add(new Nazione("Regno Unito", "gb"));
        NAZIONI.add(new Nazione("Irlanda", "ie"));
        NAZIONI.add(new Nazione("Paesi Bassi", "nl"));
        NAZIONI.add(new Nazione("Belgio", "be"));
        NAZIONI.add(new Nazione("Svizzera", "ch"));
        NAZIONI.add(new Nazione("Austria", "at"));
        NAZIONI.add(new Nazione("Polonia", "pl"));
        NAZIONI.add(new Nazione("Repubblica Ceca", "cz"));
        NAZIONI.add(new Nazione("Slovacchia", "sk"));
        NAZIONI.add(new Nazione("Ungheria", "hu"));
        NAZIONI.add(new Nazione("Romania", "ro"));
        NAZIONI.add(new Nazione("Bulgaria", "bg"));
        NAZIONI.add(new Nazione("Grecia", "gr"));
        NAZIONI.add(new Nazione("Croazia", "hr"));
        NAZIONI.add(new Nazione("Serbia", "rs"));
        NAZIONI.add(new Nazione("Slovenia", "si"));
        NAZIONI.add(new Nazione("Svezia", "se"));
        NAZIONI.add(new Nazione("Norvegia", "no"));
        NAZIONI.add(new Nazione("Danimarca", "dk"));
        NAZIONI.add(new Nazione("Finlandia", "fi"));
        NAZIONI.add(new Nazione("Islanda", "is"));
        NAZIONI.add(new Nazione("Estonia", "ee"));
        NAZIONI.add(new Nazione("Lettonia", "lv"));
        NAZIONI.add(new Nazione("Lituania", "lt"));
        NAZIONI.add(new Nazione("Ucraina", "ua"));
        NAZIONI.add(new Nazione("Albania", "al"));
        NAZIONI.add(new Nazione("Macedonia del Nord", "mk"));
        NAZIONI.add(new Nazione("Montenegro", "me"));
        NAZIONI.add(new Nazione("Bosnia ed Erzegovina", "ba"));
        NAZIONI.add(new Nazione("Moldavia", "md"));
        NAZIONI.add(new Nazione("Lussemburgo", "lu"));
        NAZIONI.add(new Nazione("Malta", "mt"));
        NAZIONI.add(new Nazione("Cipro", "cy"));
        NAZIONI.add(new Nazione("Stati Uniti", "us"));
        NAZIONI.add(new Nazione("Canada", "ca"));
        NAZIONI.add(new Nazione("Messico", "mx"));
        NAZIONI.add(new Nazione("Brasile", "br"));
        NAZIONI.add(new Nazione("Argentina", "ar"));
        NAZIONI.add(new Nazione("Colombia", "co"));
        NAZIONI.add(new Nazione("Per\u00f9", "pe"));
        NAZIONI.add(new Nazione("Cile", "cl"));
        NAZIONI.add(new Nazione("Venezuela", "ve"));
        NAZIONI.add(new Nazione("Ecuador", "ec"));
        NAZIONI.add(new Nazione("Uruguay", "uy"));
        NAZIONI.add(new Nazione("Paraguay", "py"));
        NAZIONI.add(new Nazione("Bolivia", "bo"));
        NAZIONI.add(new Nazione("Cuba", "cu"));
        NAZIONI.add(new Nazione("Giamaica", "jm"));
        NAZIONI.add(new Nazione("Panama", "pa"));
        NAZIONI.add(new Nazione("Costa Rica", "cr"));
        NAZIONI.add(new Nazione("Guatemala", "gt"));
        NAZIONI.add(new Nazione("Honduras", "hn"));
        NAZIONI.add(new Nazione("Haiti", "ht"));
        NAZIONI.add(new Nazione("Trinidad e Tobago", "tt"));
        NAZIONI.add(new Nazione("Giappone", "jp"));
        NAZIONI.add(new Nazione("Cina", "cn"));
        NAZIONI.add(new Nazione("Corea del Sud", "kr"));
        NAZIONI.add(new Nazione("Corea del Nord", "kp"));
        NAZIONI.add(new Nazione("India", "in"));
        NAZIONI.add(new Nazione("Indonesia", "id"));
        NAZIONI.add(new Nazione("Thailandia", "th"));
        NAZIONI.add(new Nazione("Vietnam", "vn"));
        NAZIONI.add(new Nazione("Filippine", "ph"));
        NAZIONI.add(new Nazione("Malesia", "my"));
        NAZIONI.add(new Nazione("Singapore", "sg"));
        NAZIONI.add(new Nazione("Turchia", "tr"));
        NAZIONI.add(new Nazione("Arabia Saudita", "sa"));
        NAZIONI.add(new Nazione("Emirati Arabi Uniti", "ae"));
        NAZIONI.add(new Nazione("Israele", "il"));
        NAZIONI.add(new Nazione("Iran", "ir"));
        NAZIONI.add(new Nazione("Iraq", "iq"));
        NAZIONI.add(new Nazione("Pakistan", "pk"));
        NAZIONI.add(new Nazione("Bangladesh", "bd"));
        NAZIONI.add(new Nazione("Nepal", "np"));
        NAZIONI.add(new Nazione("Sri Lanka", "lk"));
        NAZIONI.add(new Nazione("Mongolia", "mn"));
        NAZIONI.add(new Nazione("Kazakistan", "kz"));
        NAZIONI.add(new Nazione("Qatar", "qa"));
        NAZIONI.add(new Nazione("Giordania", "jo"));
        NAZIONI.add(new Nazione("Libano", "lb"));
        NAZIONI.add(new Nazione("Egitto", "eg"));
        NAZIONI.add(new Nazione("Sudafrica", "za"));
        NAZIONI.add(new Nazione("Nigeria", "ng"));
        NAZIONI.add(new Nazione("Kenya", "ke"));
        NAZIONI.add(new Nazione("Marocco", "ma"));
        NAZIONI.add(new Nazione("Tunisia", "tn"));
        NAZIONI.add(new Nazione("Algeria", "dz"));
        NAZIONI.add(new Nazione("Etiopia", "et"));
        NAZIONI.add(new Nazione("Ghana", "gh"));
        NAZIONI.add(new Nazione("Senegal", "sn"));
        NAZIONI.add(new Nazione("Costa d'Avorio", "ci"));
        NAZIONI.add(new Nazione("Camerun", "cm"));
        NAZIONI.add(new Nazione("Tanzania", "tz"));
        NAZIONI.add(new Nazione("Madagascar", "mg"));
        NAZIONI.add(new Nazione("Mozambico", "mz"));
        NAZIONI.add(new Nazione("Angola", "ao"));
        NAZIONI.add(new Nazione("Australia", "au"));
        NAZIONI.add(new Nazione("Nuova Zelanda", "nz"));
        NAZIONI.add(new Nazione("Fiji", "fj"));
        NAZIONI.add(new Nazione("Papua Nuova Guinea", "pg"));
        NAZIONI.add(new Nazione("Russia", "ru"));
        NAZIONI.add(new Nazione("Georgia", "ge"));
    }
}

