/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.model;

import it.quizmaster.model.Nazione;
import java.util.List;

public class Domanda {
    private final Nazione nazioneCorretta;
    private final List<Nazione> opzioni;
    private final int tempoLimiteSecondi;
    private final int puntiBase;

    public Domanda(Nazione nazioneCorretta, List<Nazione> opzioni, int tempoLimiteSecondi, int puntiBase) {
        this.nazioneCorretta = nazioneCorretta;
        this.opzioni = opzioni;
        this.tempoLimiteSecondi = tempoLimiteSecondi;
        this.puntiBase = puntiBase;
    }

    public Nazione getNazioneCorretta() {
        return this.nazioneCorretta;
    }

    public List<Nazione> getOpzioni() {
        return this.opzioni;
    }

    public int getTempoLimiteSecondi() {
        return this.tempoLimiteSecondi;
    }

    public int getPuntiBase() {
        return this.puntiBase;
    }

    public String getUrlBandiera() {
        return this.nazioneCorretta.getUrlBandiera();
    }

    public boolean isCorretta(int indice) {
        if (indice < 0 || indice >= this.opzioni.size()) {
            return false;
        }
        return this.opzioni.get(indice).equals(this.nazioneCorretta);
    }

    public int calcolaPunti(long tempoRispostaMs) {
        long tempoLimiteMs = (long)this.tempoLimiteSecondi * 1000L;
        if (tempoRispostaMs >= tempoLimiteMs) {
            return 0;
        }
        double fattoreTempo = 1.0 - (double)tempoRispostaMs / (double)tempoLimiteMs * 0.5;
        return (int)((double)this.puntiBase * fattoreTempo);
    }
}

