/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import it.quizmaster.model.Giocatore;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GestoreDati {
    private static final String NOME_FILE = "quizmaster_dati.json";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path percorsoFile;
    private Map<String, Giocatore> giocatori;

    public GestoreDati() {
        String home = System.getProperty("user.home");
        this.percorsoFile = Paths.get(home, ".quizmaster", NOME_FILE);
        this.giocatori = new HashMap<String, Giocatore>();
        this.caricaDati();
    }

    private void caricaDati() {
        try {
            Type tipo;
            String json;
            Map dati;
            if (Files.exists(this.percorsoFile, new LinkOption[0]) && (dati = (Map)gson.fromJson(json = Files.readString(this.percorsoFile), tipo = new TypeToken<Map<String, Giocatore>>(this){}.getType())) != null) {
                this.giocatori = dati;
            }
        }
        catch (IOException e) {
            System.err.println("Errore nel caricamento dati: " + e.getMessage());
        }
    }

    public void salvaDati() {
        try {
            Files.createDirectories(this.percorsoFile.getParent(), new FileAttribute[0]);
            String json = gson.toJson(this.giocatori);
            Files.writeString(this.percorsoFile, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Errore nel salvataggio dati: " + e.getMessage());
        }
    }

    public boolean registraGiocatore(String nickname) {
        if (this.giocatori.containsKey(nickname.toLowerCase())) {
            return false;
        }
        this.giocatori.put(nickname.toLowerCase(), new Giocatore(nickname));
        this.salvaDati();
        return true;
    }

    public Giocatore login(String nickname) {
        return this.giocatori.get(nickname.toLowerCase());
    }

    public boolean esisteGiocatore(String nickname) {
        return this.giocatori.containsKey(nickname.toLowerCase());
    }

    public List<Giocatore> getClassifica() {
        ArrayList<Giocatore> lista = new ArrayList<Giocatore>(this.giocatori.values());
        lista.sort(Comparator.comparingInt(Giocatore::getPunteggioTotale).reversed());
        return lista;
    }

    public int getPosizione(String nickname) {
        List<Giocatore> classifica = this.getClassifica();
        for (int i = 0; i < classifica.size(); ++i) {
            if (!classifica.get(i).getNickname().equalsIgnoreCase(nickname)) continue;
            return i + 1;
        }
        return -1;
    }
}

