/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.model;

public class Giocatore {
    private String nickname;
    private int punteggioTotale;
    private int risposteCorrette;
    private int risposteSbagliate;
    private int risposteSaltate;
    private int quizCompletati;

    public Giocatore() {
    }

    public Giocatore(String nickname) {
        this.nickname = nickname;
        this.punteggioTotale = 0;
        this.risposteCorrette = 0;
        this.risposteSbagliate = 0;
        this.risposteSaltate = 0;
        this.quizCompletati = 0;
    }

    public String getNickname() {
        return this.nickname;
    }

    public int getPunteggioTotale() {
        return this.punteggioTotale;
    }

    public int getRisposteCorrette() {
        return this.risposteCorrette;
    }

    public int getRisposteSbagliate() {
        return this.risposteSbagliate;
    }

    public int getRisposteSaltate() {
        return this.risposteSaltate;
    }

    public int getQuizCompletati() {
        return this.quizCompletati;
    }

    public int getRisposteTotali() {
        return this.risposteCorrette + this.risposteSbagliate + this.risposteSaltate;
    }

    public double getPercentualeCorrette() {
        int totali = this.getRisposteTotali();
        if (totali == 0) {
            return 0.0;
        }
        return (double)this.risposteCorrette / (double)totali * 100.0;
    }

    public void aggiungiPunti(int punti) {
        this.punteggioTotale += punti;
    }

    public void registraRispostaCorretta() {
        ++this.risposteCorrette;
    }

    public void registraRispostaSbagliata() {
        ++this.risposteSbagliate;
    }

    public void registraRispostaSaltata() {
        ++this.risposteSaltate;
    }

    public void completaQuiz() {
        ++this.quizCompletati;
    }

    public String toString() {
        return this.nickname + " (" + this.punteggioTotale + " punti)";
    }
}

