/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.model;

import it.quizmaster.model.Domanda;
import it.quizmaster.model.RisultatoRisposta;
import java.util.ArrayList;
import java.util.List;

public class SessioneQuiz {
    private final List<Domanda> domande;
    private final List<RisultatoRisposta> risultati;
    private final List<Integer> puntiPerDomanda;
    private int domandaCorrente;
    private int punteggioSessione;

    public SessioneQuiz(List<Domanda> domande) {
        this.domande = domande;
        this.risultati = new ArrayList<RisultatoRisposta>();
        this.puntiPerDomanda = new ArrayList<Integer>();
        this.domandaCorrente = 0;
        this.punteggioSessione = 0;
    }

    public Domanda getDomandaCorrente() {
        if (this.domandaCorrente < this.domande.size()) {
            return this.domande.get(this.domandaCorrente);
        }
        return null;
    }

    public int getNumeroDomandaCorrente() {
        return this.domandaCorrente + 1;
    }

    public int getTotaleDomande() {
        return this.domande.size();
    }

    public boolean hasProssimaDomanda() {
        return this.domandaCorrente < this.domande.size();
    }

    public void registraRisposta(RisultatoRisposta risultato, int punti) {
        this.risultati.add(risultato);
        this.puntiPerDomanda.add(punti);
        this.punteggioSessione += punti;
        ++this.domandaCorrente;
    }

    public int getPunteggioSessione() {
        return this.punteggioSessione;
    }

    public int getCorrette() {
        return (int)this.risultati.stream().filter(r -> r == RisultatoRisposta.CORRETTA).count();
    }

    public int getSbagliate() {
        return (int)this.risultati.stream().filter(r -> r == RisultatoRisposta.SBAGLIATA).count();
    }

    public int getSaltate() {
        return (int)this.risultati.stream().filter(r -> r == RisultatoRisposta.SALTATA || r == RisultatoRisposta.TEMPO_SCADUTO).count();
    }

    public List<RisultatoRisposta> getRisultati() {
        return this.risultati;
    }

    public List<Integer> getPuntiPerDomanda() {
        return this.puntiPerDomanda;
    }

    public List<Domanda> getDomande() {
        return this.domande;
    }
}

