/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.view;

import it.quizmaster.App;
import it.quizmaster.model.Giocatore;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class SchermataClassifica {
    private final App app;

    public SchermataClassifica(App app) {
        this.app = app;
    }

    public StackPane crea() {
        StackPane root = new StackPane();
        VBox container = new VBox(20.0);
        container.setAlignment(Pos.TOP_CENTER);
        container.setPadding(new Insets(30.0, 40.0, 30.0, 40.0));
        container.setMaxWidth(550.0);
        Label titolo = new Label("\ud83c\udfc5 Classifica Globale");
        titolo.getStyleClass().add((Object)"section-title");
        titolo.setStyle("-fx-font-size: 30px;");
        List<Giocatore> classifica = this.app.getGestoreDati().getClassifica();
        String nicknameCorrente = this.app.getGiocatoreCorrente().getNickname();
        if (classifica.isEmpty()) {
            Label vuota = new Label("Nessun giocatore in classifica.\nGioca un quiz per entrare!");
            vuota.getStyleClass().addAll((Object[])new String[]{"text-muted", "text-large"});
            vuota.setWrapText(true);
            vuota.setStyle("-fx-text-alignment: center;");
            container.getChildren().addAll((Object[])new Node[]{titolo, vuota});
        } else {
            if (classifica.size() >= 1) {
                HBox podio = this.creaPodio(classifica);
                container.getChildren().addAll((Object[])new Node[]{titolo, podio});
            }
            VBox listaBox = new VBox(8.0);
            listaBox.getStyleClass().add((Object)"card-light");
            listaBox.setPadding(new Insets(15.0));
            int max = Math.min(classifica.size(), 20);
            for (int i = 0; i < max; ++i) {
                Giocatore g = classifica.get(i);
                boolean isCorrente = g.getNickname().equalsIgnoreCase(nicknameCorrente);
                HBox riga = this.creaRigaClassifica(i + 1, g, isCorrente);
                listaBox.getChildren().add((Object)riga);
            }
            ScrollPane scroll = new ScrollPane((Node)listaBox);
            scroll.setFitToWidth(true);
            scroll.setStyle("-fx-background-color: transparent; -fx-background: transparent;");
            scroll.setMaxHeight(350.0);
            container.getChildren().add((Object)scroll);
        }
        Button btnIndietro = new Button("\u2190 Torna al Menu");
        btnIndietro.getStyleClass().add((Object)"btn-secondary");
        btnIndietro.setOnAction(e -> this.app.mostraMenu());
        container.getChildren().add((Object)btnIndietro);
        root.getChildren().add((Object)container);
        container.setOpacity(0.0);
        FadeTransition fade = new FadeTransition(Duration.millis((double)400.0), (Node)container);
        fade.setToValue(1.0);
        fade.play();
        return root;
    }

    private HBox creaPodio(List<Giocatore> classifica) {
        int[] ordine;
        HBox podio = new HBox(15.0);
        podio.setAlignment(Pos.BOTTOM_CENTER);
        podio.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        String[] medaglie = new String[]{"\ud83e\udd47", "\ud83e\udd48", "\ud83e\udd49"};
        String[] colori = new String[]{"#ffd700", "#c0c0c0", "#cd7f32"};
        int[] altezze = new int[]{120, 95, 80};
        for (int idx : ordine = new int[]{1, 0, 2}) {
            if (idx >= classifica.size()) continue;
            Giocatore g = classifica.get(idx);
            VBox podioItem = new VBox(5.0);
            podioItem.setAlignment(Pos.CENTER);
            podioItem.setMinWidth(120.0);
            podioItem.setMinHeight((double)altezze[idx]);
            podioItem.setStyle("-fx-background-color: rgba(22, 33, 62, 0.7);-fx-background-radius: 12;-fx-padding: 10;-fx-border-color: " + colori[idx] + ";-fx-border-radius: 12;-fx-border-width: 2;");
            Label medaglia = new Label(medaglie[idx]);
            medaglia.setStyle("-fx-font-size: 30px;");
            Label nome = new Label(g.getNickname());
            nome.getStyleClass().add((Object)"text-white");
            nome.setStyle("-fx-font-weight: bold; -fx-font-size: 14px;");
            nome.setMaxWidth(110.0);
            nome.setWrapText(true);
            nome.setAlignment(Pos.CENTER);
            Label punti = new Label(g.getPunteggioTotale() + " pt");
            punti.setStyle("-fx-font-weight: bold; -fx-text-fill: " + colori[idx] + ";");
            podioItem.getChildren().addAll((Object[])new Node[]{medaglia, nome, punti});
            podio.getChildren().add((Object)podioItem);
        }
        return podio;
    }

    private HBox creaRigaClassifica(int posizione, Giocatore g, boolean evidenziata) {
        HBox riga = new HBox(12.0);
        riga.setAlignment(Pos.CENTER_LEFT);
        riga.setPadding(new Insets(8.0, 12.0, 8.0, 12.0));
        if (evidenziata) {
            riga.getStyleClass().add((Object)"classifica-riga-evidenziata");
        } else {
            riga.getStyleClass().add((Object)"classifica-riga");
        }
        Label posLabel = new Label();
        posLabel.setMinWidth(40.0);
        if (posizione == 1) {
            posLabel.setText("\ud83e\udd47");
        } else if (posizione == 2) {
            posLabel.setText("\ud83e\udd48");
        } else if (posizione == 3) {
            posLabel.setText("\ud83e\udd49");
        } else {
            posLabel.setText("#" + posizione);
        }
        posLabel.setStyle(posizione <= 3 ? "-fx-font-size: 20px;" : "-fx-font-size: 15px; -fx-text-fill: #a0a0b0; -fx-font-weight: bold;");
        Label nomeLabel = new Label(g.getNickname());
        nomeLabel.getStyleClass().add((Object)"text-white");
        nomeLabel.setStyle("-fx-font-size: 15px;" + (evidenziata ? " -fx-font-weight: bold;" : ""));
        HBox.setHgrow((Node)nomeLabel, (Priority)Priority.ALWAYS);
        Label quizLabel = new Label(g.getQuizCompletati() + " quiz");
        quizLabel.getStyleClass().add((Object)"text-muted");
        quizLabel.setStyle("-fx-font-size: 12px;");
        Label puntiLabel = new Label(g.getPunteggioTotale() + " pt");
        puntiLabel.setStyle("-fx-font-weight: bold; -fx-font-size: 15px; -fx-text-fill: " + (evidenziata ? "#e94560" : "#eaeaea") + ";");
        puntiLabel.setMinWidth(70.0);
        puntiLabel.setAlignment(Pos.CENTER_RIGHT);
        riga.getChildren().addAll((Object[])new Node[]{posLabel, nomeLabel, quizLabel, puntiLabel});
        return riga;
    }
}

