/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.view;

import it.quizmaster.App;
import it.quizmaster.model.Giocatore;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class SchermataLogin {
    private final App app;

    public SchermataLogin(App app) {
        this.app = app;
    }

    public StackPane crea() {
        StackPane root = new StackPane();
        VBox container = new VBox(20.0);
        container.setAlignment(Pos.CENTER);
        container.setMaxWidth(420.0);
        container.setMaxHeight(500.0);
        container.getStyleClass().add((Object)"card");
        Label icona = new Label("\ud83c\udf0d");
        icona.setStyle("-fx-font-size: 60px;");
        Label titolo = new Label("QuizMaster");
        titolo.getStyleClass().add((Object)"title");
        Label sottotitolo = new Label("Quanto conosci le bandiere del mondo?");
        sottotitolo.getStyleClass().addAll((Object[])new String[]{"text-muted", "text-large"});
        sottotitolo.setWrapText(true);
        sottotitolo.setTextAlignment(TextAlignment.CENTER);
        TextField campoNickname = new TextField();
        campoNickname.setPromptText("Inserisci il tuo nickname...");
        campoNickname.getStyleClass().add((Object)"text-field-custom");
        campoNickname.setMaxWidth(300.0);
        Label labelErrore = new Label();
        labelErrore.getStyleClass().add((Object)"error-label");
        labelErrore.setVisible(false);
        labelErrore.setManaged(false);
        Button btnAccedi = new Button("Accedi / Registrati");
        btnAccedi.getStyleClass().add((Object)"btn-primary");
        btnAccedi.setMaxWidth(300.0);
        Label info = new Label("Se il nickname non esiste, verr\u00e0 creato un nuovo profilo.");
        info.getStyleClass().add((Object)"text-muted");
        info.setStyle("-fx-font-size: 12px;");
        info.setWrapText(true);
        info.setTextAlignment(TextAlignment.CENTER);
        info.setMaxWidth(300.0);
        Runnable azioneAccedi = () -> {
            Giocatore g;
            String nickname = campoNickname.getText().trim();
            if (nickname.isEmpty()) {
                this.mostraErrore(labelErrore, "Inserisci un nickname!");
                return;
            }
            if (nickname.length() < 3) {
                this.mostraErrore(labelErrore, "Il nickname deve avere almeno 3 caratteri.");
                return;
            }
            if (nickname.length() > 20) {
                this.mostraErrore(labelErrore, "Il nickname non pu\u00f2 superare i 20 caratteri.");
                return;
            }
            if (!this.app.getGestoreDati().esisteGiocatore(nickname)) {
                this.app.getGestoreDati().registraGiocatore(nickname);
            }
            if ((g = this.app.getGestoreDati().login(nickname)) != null) {
                this.app.setGiocatoreCorrente(g);
                this.app.mostraMenu();
            } else {
                this.mostraErrore(labelErrore, "Errore nel login. Riprova.");
            }
        };
        btnAccedi.setOnAction(e -> azioneAccedi.run());
        campoNickname.setOnAction(e -> azioneAccedi.run());
        Region spacer1 = new Region();
        spacer1.setPrefHeight(5.0);
        Region spacer2 = new Region();
        spacer2.setPrefHeight(5.0);
        container.getChildren().addAll((Object[])new Node[]{icona, titolo, sottotitolo, spacer1, campoNickname, labelErrore, btnAccedi, spacer2, info});
        container.setOpacity(0.0);
        container.setTranslateY(30.0);
        FadeTransition fade = new FadeTransition(Duration.millis((double)600.0), (Node)container);
        fade.setToValue(1.0);
        TranslateTransition slide = new TranslateTransition(Duration.millis((double)600.0), (Node)container);
        slide.setToY(0.0);
        new ParallelTransition(new Animation[]{fade, slide}).play();
        root.getChildren().add((Object)container);
        return root;
    }

    private void mostraErrore(Label label, String messaggio) {
        label.setText(messaggio);
        label.setVisible(true);
        label.setManaged(true);
        TranslateTransition shake = new TranslateTransition(Duration.millis((double)50.0), (Node)label);
        shake.setFromX(-5.0);
        shake.setToX(5.0);
        shake.setCycleCount(6);
        shake.setAutoReverse(true);
        shake.setOnFinished(e -> label.setTranslateX(0.0));
        shake.play();
    }
}

