/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.view;

import it.quizmaster.App;
import it.quizmaster.model.Giocatore;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class SchermataMenu {
    private final App app;

    public SchermataMenu(App app) {
        this.app = app;
    }

    public StackPane crea() {
        StackPane root = new StackPane();
        VBox container = new VBox(18.0);
        container.setAlignment(Pos.CENTER);
        container.setMaxWidth(500.0);
        Giocatore g = this.app.getGiocatoreCorrente();
        Label icona = new Label("\ud83c\udff3\ufe0f");
        icona.setStyle("-fx-font-size: 50px;");
        Label benvenuto = new Label("Bentornato, " + g.getNickname() + "!");
        benvenuto.getStyleClass().addAll((Object[])new String[]{"section-title"});
        benvenuto.setWrapText(true);
        benvenuto.setTextAlignment(TextAlignment.CENTER);
        HBox statsBox = new HBox(20.0);
        statsBox.setAlignment(Pos.CENTER);
        statsBox.getChildren().addAll((Object[])new Node[]{this.creaStatMini("\ud83c\udfc6", String.valueOf(g.getPunteggioTotale()), "Punti"), this.creaStatMini("\ud83d\udcdd", String.valueOf(g.getQuizCompletati()), "Quiz"), this.creaStatMini("\u2705", String.format("%.0f%%", g.getPercentualeCorrette()), "Precisione")});
        Region spacer = new Region();
        spacer.setPrefHeight(15.0);
        Button btnGioca = new Button("\ud83c\udfae  Inizia Quiz");
        btnGioca.getStyleClass().add((Object)"btn-menu");
        btnGioca.setOnAction(e -> this.app.mostraQuiz());
        Button btnStatistiche = new Button("\ud83d\udcca  Statistiche");
        btnStatistiche.getStyleClass().add((Object)"btn-menu");
        btnStatistiche.setOnAction(e -> this.app.mostraStatistiche());
        Button btnClassifica = new Button("\ud83c\udfc5  Classifica");
        btnClassifica.getStyleClass().add((Object)"btn-menu");
        btnClassifica.setOnAction(e -> this.app.mostraClassifica());
        Button btnLogout = new Button("\ud83d\udeaa  Cambia Utente");
        btnLogout.getStyleClass().add((Object)"btn-secondary");
        btnLogout.setOnAction(e -> {
            this.app.getGestoreDati().salvaDati();
            this.app.setGiocatoreCorrente(null);
            this.app.mostraLogin();
        });
        Button btnEsci = new Button("Esci");
        btnEsci.getStyleClass().add((Object)"btn-secondary");
        btnEsci.setStyle("-fx-text-fill: #a0a0b0; -fx-border-color: #a0a0b0;");
        btnEsci.setOnAction(e -> {
            this.app.getGestoreDati().salvaDati();
            this.app.getStage().close();
        });
        HBox bottomBtns = new HBox(15.0, new Node[]{btnLogout, btnEsci});
        bottomBtns.setAlignment(Pos.CENTER);
        container.getChildren().addAll((Object[])new Node[]{icona, benvenuto, statsBox, spacer, btnGioca, btnStatistiche, btnClassifica, new Region(this){
            {
                this.setPrefHeight(10.0);
            }
        }, bottomBtns});
        this.animaEntrata(container);
        root.getChildren().add((Object)container);
        return root;
    }

    private VBox creaStatMini(String emoji, String valore, String etichetta) {
        VBox box = new VBox(3.0);
        box.setAlignment(Pos.CENTER);
        box.getStyleClass().add((Object)"stat-card");
        Label iconLabel = new Label(emoji);
        iconLabel.setStyle("-fx-font-size: 22px;");
        Label valLabel = new Label(valore);
        valLabel.getStyleClass().addAll((Object[])new String[]{"text-white"});
        valLabel.setStyle("-fx-font-size: 20px; -fx-font-weight: bold;");
        Label etLabel = new Label(etichetta);
        etLabel.getStyleClass().add((Object)"text-muted");
        etLabel.setStyle("-fx-font-size: 12px;");
        box.getChildren().addAll((Object[])new Node[]{iconLabel, valLabel, etLabel});
        return box;
    }

    private void animaEntrata(VBox container) {
        container.setOpacity(0.0);
        container.setTranslateY(20.0);
        FadeTransition fade = new FadeTransition(Duration.millis((double)500.0), (Node)container);
        fade.setToValue(1.0);
        TranslateTransition slide = new TranslateTransition(Duration.millis((double)500.0), (Node)container);
        slide.setToY(0.0);
        new ParallelTransition(new Animation[]{fade, slide}).play();
    }
}

