/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.view;

import it.quizmaster.App;
import it.quizmaster.model.Domanda;
import it.quizmaster.model.Nazione;
import it.quizmaster.model.RisultatoRisposta;
import it.quizmaster.model.SessioneQuiz;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.PauseTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class SchermataQuiz {
    private final App app;
    private final SessioneQuiz sessione;
    private StackPane root;
    private Label labelProgresso;
    private Label labelPunteggio;
    private Label labelTimer;
    private ProgressBar barraTimer;
    private ImageView immagineBandiera;
    private StackPane flagContainer;
    private Button[] bottoniOpzioni;
    private Button btnSalta;
    private VBox containerDomanda;
    private Label labelFeedback;
    private Label labelDomanda;
    private Timeline timerTimeline;
    private long inizioRispostaMs;
    private boolean rispostaData;

    public SchermataQuiz(App app, SessioneQuiz sessione) {
        this.app = app;
        this.sessione = sessione;
    }

    public StackPane crea() {
        this.root = new StackPane();
        VBox mainLayout = new VBox(15.0);
        mainLayout.setAlignment(Pos.TOP_CENTER);
        mainLayout.setPadding(new Insets(20.0, 40.0, 20.0, 40.0));
        mainLayout.setMaxWidth(800.0);
        HBox topBar = this.creaTopBar();
        VBox timerBox = this.creaTimerBox();
        this.labelDomanda = new Label("A quale nazione appartiene questa bandiera?");
        this.labelDomanda.getStyleClass().addAll((Object[])new String[]{"text-white", "text-large"});
        this.labelDomanda.setWrapText(true);
        this.labelDomanda.setTextAlignment(TextAlignment.CENTER);
        this.labelDomanda.setStyle("-fx-font-size: 20px; -fx-font-weight: bold;");
        this.flagContainer = new StackPane();
        this.flagContainer.getStyleClass().add((Object)"flag-container");
        this.flagContainer.setMaxWidth(320.0);
        this.flagContainer.setMaxHeight(220.0);
        this.flagContainer.setMinHeight(200.0);
        this.immagineBandiera = new ImageView();
        this.immagineBandiera.setFitWidth(310.0);
        this.immagineBandiera.setFitHeight(200.0);
        this.immagineBandiera.setPreserveRatio(true);
        this.immagineBandiera.setSmooth(true);
        Label loadingLabel = new Label("\u23f3 Caricamento...");
        loadingLabel.getStyleClass().add((Object)"text-muted");
        this.flagContainer.getChildren().addAll((Object[])new Node[]{loadingLabel, this.immagineBandiera});
        this.labelFeedback = new Label();
        this.labelFeedback.setStyle("-fx-font-size: 18px; -fx-font-weight: bold;");
        this.labelFeedback.setVisible(false);
        this.labelFeedback.setManaged(false);
        GridPane griglia = this.creaGrigliaOpzioni();
        this.btnSalta = new Button("\u23ed Salta domanda");
        this.btnSalta.getStyleClass().add((Object)"btn-skip");
        this.btnSalta.setOnAction(e -> this.gestisciSalta());
        this.containerDomanda = new VBox(15.0);
        this.containerDomanda.setAlignment(Pos.CENTER);
        this.containerDomanda.getChildren().addAll((Object[])new Node[]{this.labelDomanda, this.flagContainer, this.labelFeedback, griglia, this.btnSalta});
        mainLayout.getChildren().addAll((Object[])new Node[]{topBar, timerBox, this.containerDomanda});
        StackPane.setAlignment((Node)mainLayout, (Pos)Pos.TOP_CENTER);
        this.root.getChildren().add((Object)mainLayout);
        Platform.runLater(this::caricaDomanda);
        return this.root;
    }

    private HBox creaTopBar() {
        this.labelProgresso = new Label();
        this.labelProgresso.getStyleClass().addAll((Object[])new String[]{"text-muted", "text-large"});
        this.labelPunteggio = new Label("0 punti");
        this.labelPunteggio.getStyleClass().add((Object)"text-white");
        this.labelPunteggio.setStyle("-fx-font-size: 18px; -fx-font-weight: bold;");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        HBox topBar = new HBox();
        topBar.setAlignment(Pos.CENTER);
        topBar.getChildren().addAll((Object[])new Node[]{this.labelProgresso, spacer, this.labelPunteggio});
        return topBar;
    }

    private VBox creaTimerBox() {
        this.labelTimer = new Label("15");
        this.labelTimer.getStyleClass().addAll((Object[])new String[]{"text-white"});
        this.labelTimer.setStyle("-fx-font-size: 16px; -fx-font-weight: bold;");
        this.barraTimer = new ProgressBar(1.0);
        this.barraTimer.getStyleClass().add((Object)"progress-bar-timer");
        this.barraTimer.setMaxWidth(Double.MAX_VALUE);
        this.barraTimer.setPrefHeight(8.0);
        HBox timerHeader = new HBox(10.0);
        timerHeader.setAlignment(Pos.CENTER_LEFT);
        Label timerIcon = new Label("\u23f1");
        timerIcon.setStyle("-fx-font-size: 16px;");
        timerHeader.getChildren().addAll((Object[])new Node[]{timerIcon, this.labelTimer});
        VBox timerBox = new VBox(5.0, new Node[]{timerHeader, this.barraTimer});
        return timerBox;
    }

    private GridPane creaGrigliaOpzioni() {
        GridPane griglia = new GridPane();
        griglia.setHgap(15.0);
        griglia.setVgap(12.0);
        griglia.setAlignment(Pos.CENTER);
        this.bottoniOpzioni = new Button[4];
        for (int i = 0; i < 4; ++i) {
            int indice = i;
            this.bottoniOpzioni[i] = new Button();
            this.bottoniOpzioni[i].getStyleClass().add((Object)"btn-opzione");
            this.bottoniOpzioni[i].setOnAction(e -> this.gestisciRisposta(indice));
            this.bottoniOpzioni[i].setWrapText(true);
            int riga = i / 2;
            int col = i % 2;
            griglia.add((Node)this.bottoniOpzioni[i], col, riga);
        }
        ColumnConstraints cc = new ColumnConstraints();
        cc.setPercentWidth(50.0);
        griglia.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{cc, new ColumnConstraints(this){
            {
                this.setPercentWidth(50.0);
            }
        }});
        return griglia;
    }

    private void caricaDomanda() {
        if (!this.sessione.hasProssimaDomanda()) {
            this.terminaQuiz();
            return;
        }
        Domanda domanda = this.sessione.getDomandaCorrente();
        this.rispostaData = false;
        this.labelProgresso.setText("Domanda " + this.sessione.getNumeroDomandaCorrente() + " / " + this.sessione.getTotaleDomande());
        this.labelFeedback.setVisible(false);
        this.labelFeedback.setManaged(false);
        try {
            Image img = new Image(domanda.getUrlBandiera(), 310.0, 200.0, true, true, true);
            this.immagineBandiera.setImage(img);
            this.immagineBandiera.setEffect(null);
        }
        catch (Exception e) {
            System.err.println("Errore caricamento bandiera: " + e.getMessage());
        }
        List<Nazione> opzioni = domanda.getOpzioni();
        for (int i = 0; i < 4 && i < opzioni.size(); ++i) {
            this.bottoniOpzioni[i].setText(opzioni.get(i).getNome());
            this.bottoniOpzioni[i].getStyleClass().removeAll((Object[])new String[]{"btn-opzione-corretta", "btn-opzione-sbagliata"});
            this.bottoniOpzioni[i].setDisable(false);
            this.bottoniOpzioni[i].setOpacity(1.0);
        }
        this.btnSalta.setDisable(false);
        this.btnSalta.setVisible(true);
        this.avviaTimer(domanda.getTempoLimiteSecondi());
        this.containerDomanda.setOpacity(0.0);
        FadeTransition fade = new FadeTransition(Duration.millis((double)300.0), (Node)this.containerDomanda);
        fade.setToValue(1.0);
        fade.play();
    }

    private void avviaTimer(int secondi) {
        if (this.timerTimeline != null) {
            this.timerTimeline.stop();
        }
        this.inizioRispostaMs = System.currentTimeMillis();
        int totalMs = secondi * 1000;
        this.barraTimer.setProgress(1.0);
        this.barraTimer.getStyleClass().removeAll((Object[])new String[]{"progress-bar-warning", "progress-bar-danger"});
        this.labelTimer.setText(String.valueOf(secondi));
        this.timerTimeline = new Timeline();
        this.timerTimeline.setCycleCount(-1);
        KeyFrame frame = new KeyFrame(Duration.millis((double)50.0), e -> {
            long trascorso = System.currentTimeMillis() - this.inizioRispostaMs;
            double progresso = 1.0 - (double)trascorso / (double)totalMs;
            int rimanente = (int)Math.ceil((double)((long)totalMs - trascorso) / 1000.0);
            if (progresso <= 0.0) {
                this.timerTimeline.stop();
                this.gestisciTempoScaduto();
                return;
            }
            this.barraTimer.setProgress(Math.max(0.0, progresso));
            this.labelTimer.setText(String.valueOf(Math.max(0, rimanente)));
            this.barraTimer.getStyleClass().removeAll((Object[])new String[]{"progress-bar-warning", "progress-bar-danger"});
            if (progresso < 0.2) {
                this.barraTimer.getStyleClass().add((Object)"progress-bar-danger");
                this.labelTimer.setStyle("-fx-font-size: 16px; -fx-font-weight: bold; -fx-text-fill: #e74c3c;");
            } else if (progresso < 0.4) {
                this.barraTimer.getStyleClass().add((Object)"progress-bar-warning");
                this.labelTimer.setStyle("-fx-font-size: 16px; -fx-font-weight: bold; -fx-text-fill: #f39c12;");
            } else {
                this.labelTimer.setStyle("-fx-font-size: 16px; -fx-font-weight: bold; -fx-text-fill: white;");
            }
        }, new KeyValue[0]);
        this.timerTimeline.getKeyFrames().add((Object)frame);
        this.timerTimeline.play();
    }

    private void gestisciRisposta(int indice) {
        if (this.rispostaData) {
            return;
        }
        this.rispostaData = true;
        if (this.timerTimeline != null) {
            this.timerTimeline.stop();
        }
        Domanda domanda = this.sessione.getDomandaCorrente();
        long tempoMs = System.currentTimeMillis() - this.inizioRispostaMs;
        boolean corretta = domanda.isCorretta(indice);
        for (Button btn : this.bottoniOpzioni) {
            btn.setDisable(true);
        }
        this.btnSalta.setDisable(true);
        for (int i = 0; i < 4; ++i) {
            if (!domanda.isCorretta(i)) continue;
            this.bottoniOpzioni[i].getStyleClass().add((Object)"btn-opzione-corretta");
        }
        if (corretta) {
            int punti = domanda.calcolaPunti(tempoMs);
            this.sessione.registraRisposta(RisultatoRisposta.CORRETTA, punti);
            this.app.getGiocatoreCorrente().aggiungiPunti(punti);
            this.app.getGiocatoreCorrente().registraRispostaCorretta();
            this.mostraFeedback("\u2705 Corretto! +" + punti + " punti", "#2ecc71");
            this.animaPunteggio();
        } else {
            this.bottoniOpzioni[indice].getStyleClass().add((Object)"btn-opzione-sbagliata");
            this.sessione.registraRisposta(RisultatoRisposta.SBAGLIATA, 0);
            this.app.getGiocatoreCorrente().registraRispostaSbagliata();
            String nomeCorretto = domanda.getNazioneCorretta().getNome();
            this.mostraFeedback("\u274c Sbagliato! Era: " + nomeCorretto, "#e74c3c");
        }
        this.labelPunteggio.setText(this.sessione.getPunteggioSessione() + " punti");
        PauseTransition pausa = new PauseTransition(Duration.millis((double)1800.0));
        pausa.setOnFinished(e -> this.caricaDomanda());
        pausa.play();
    }

    private void gestisciSalta() {
        if (this.rispostaData) {
            return;
        }
        this.rispostaData = true;
        if (this.timerTimeline != null) {
            this.timerTimeline.stop();
        }
        Domanda domanda = this.sessione.getDomandaCorrente();
        this.sessione.registraRisposta(RisultatoRisposta.SALTATA, 0);
        this.app.getGiocatoreCorrente().registraRispostaSaltata();
        for (int i = 0; i < 4; ++i) {
            this.bottoniOpzioni[i].setDisable(true);
            if (!domanda.isCorretta(i)) continue;
            this.bottoniOpzioni[i].getStyleClass().add((Object)"btn-opzione-corretta");
        }
        this.btnSalta.setDisable(true);
        String nomeCorretto = domanda.getNazioneCorretta().getNome();
        this.mostraFeedback("\u23ed Saltata! Era: " + nomeCorretto, "#f39c12");
        PauseTransition pausa = new PauseTransition(Duration.millis((double)1500.0));
        pausa.setOnFinished(e -> this.caricaDomanda());
        pausa.play();
    }

    private void gestisciTempoScaduto() {
        if (this.rispostaData) {
            return;
        }
        this.rispostaData = true;
        Domanda domanda = this.sessione.getDomandaCorrente();
        this.sessione.registraRisposta(RisultatoRisposta.TEMPO_SCADUTO, 0);
        this.app.getGiocatoreCorrente().registraRispostaSaltata();
        for (int i = 0; i < 4; ++i) {
            this.bottoniOpzioni[i].setDisable(true);
            if (!domanda.isCorretta(i)) continue;
            this.bottoniOpzioni[i].getStyleClass().add((Object)"btn-opzione-corretta");
        }
        this.btnSalta.setDisable(true);
        String nomeCorretto = domanda.getNazioneCorretta().getNome();
        this.mostraFeedback("\u23f0 Tempo scaduto! Era: " + nomeCorretto, "#e74c3c");
        PauseTransition pausa = new PauseTransition(Duration.millis((double)1800.0));
        pausa.setOnFinished(e -> this.caricaDomanda());
        pausa.play();
    }

    private void mostraFeedback(String testo, String colore) {
        this.labelFeedback.setText(testo);
        this.labelFeedback.setStyle("-fx-font-size: 18px; -fx-font-weight: bold; -fx-text-fill: " + colore + ";");
        this.labelFeedback.setVisible(true);
        this.labelFeedback.setManaged(true);
        this.labelFeedback.setOpacity(0.0);
        this.labelFeedback.setScaleX(0.8);
        this.labelFeedback.setScaleY(0.8);
        FadeTransition fade = new FadeTransition(Duration.millis((double)200.0), (Node)this.labelFeedback);
        fade.setToValue(1.0);
        ScaleTransition scale = new ScaleTransition(Duration.millis((double)200.0), (Node)this.labelFeedback);
        scale.setToX(1.0);
        scale.setToY(1.0);
        new ParallelTransition(new Animation[]{fade, scale}).play();
    }

    private void animaPunteggio() {
        ScaleTransition scale = new ScaleTransition(Duration.millis((double)200.0), (Node)this.labelPunteggio);
        scale.setToX(1.3);
        scale.setToY(1.3);
        scale.setAutoReverse(true);
        scale.setCycleCount(2);
        scale.play();
    }

    private void terminaQuiz() {
        if (this.timerTimeline != null) {
            this.timerTimeline.stop();
        }
        this.app.getGiocatoreCorrente().completaQuiz();
        this.app.getGestoreDati().salvaDati();
        this.app.mostraRisultati(this.sessione);
    }
}

