/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.view;

import it.quizmaster.App;
import it.quizmaster.model.Domanda;
import it.quizmaster.model.RisultatoRisposta;
import it.quizmaster.model.SessioneQuiz;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class SchermataRisultati {
    private final App app;
    private final SessioneQuiz sessione;

    public SchermataRisultati(App app, SessioneQuiz sessione) {
        this.app = app;
        this.sessione = sessione;
    }

    public StackPane crea() {
        String messaggio;
        String emoji;
        double percentuale;
        StackPane root = new StackPane();
        ScrollPane scroll = new ScrollPane();
        scroll.setFitToWidth(true);
        scroll.setStyle("-fx-background-color: transparent; -fx-background: transparent;");
        VBox container = new VBox(20.0);
        container.setAlignment(Pos.CENTER);
        container.setPadding(new Insets(30.0, 40.0, 30.0, 40.0));
        container.setMaxWidth(600.0);
        double d = percentuale = this.sessione.getTotaleDomande() > 0 ? (double)this.sessione.getCorrette() / (double)this.sessione.getTotaleDomande() * 100.0 : 0.0;
        if (percentuale >= 90.0) {
            emoji = "\ud83c\udfc6";
            messaggio = "Eccezionale!";
        } else if (percentuale >= 70.0) {
            emoji = "\ud83c\udf1f";
            messaggio = "Ottimo lavoro!";
        } else if (percentuale >= 50.0) {
            emoji = "\ud83d\udc4d";
            messaggio = "Buon risultato!";
        } else if (percentuale >= 30.0) {
            emoji = "\ud83d\udcda";
            messaggio = "Puoi migliorare!";
        } else {
            emoji = "\ud83d\udcaa";
            messaggio = "Non arrenderti!";
        }
        Label emojiLabel = new Label(emoji);
        emojiLabel.setStyle("-fx-font-size: 70px;");
        Label titoloLabel = new Label(messaggio);
        titoloLabel.getStyleClass().add((Object)"title");
        titoloLabel.setStyle("-fx-font-size: 36px;");
        Label subtitleLabel = new Label("Quiz completato!");
        subtitleLabel.getStyleClass().addAll((Object[])new String[]{"text-muted", "text-large"});
        VBox punteggioBox = new VBox(5.0);
        punteggioBox.setAlignment(Pos.CENTER);
        punteggioBox.getStyleClass().add((Object)"card-light");
        punteggioBox.setPadding(new Insets(20.0));
        Label punteggioVal = new Label(String.valueOf(this.sessione.getPunteggioSessione()));
        punteggioVal.getStyleClass().add((Object)"text-xxl");
        punteggioVal.setStyle("-fx-text-fill: #e94560;");
        Label punteggioEtichetta = new Label("punti guadagnati");
        punteggioEtichetta.getStyleClass().addAll((Object[])new String[]{"text-muted", "text-large"});
        punteggioBox.getChildren().addAll((Object[])new Node[]{punteggioVal, punteggioEtichetta});
        HBox statsRow = new HBox(15.0);
        statsRow.setAlignment(Pos.CENTER);
        statsRow.getChildren().addAll((Object[])new Node[]{this.creaStatCard("\u2705", String.valueOf(this.sessione.getCorrette()), "Corrette", "#2ecc71"), this.creaStatCard("\u274c", String.valueOf(this.sessione.getSbagliate()), "Sbagliate", "#e74c3c"), this.creaStatCard("\u23ed", String.valueOf(this.sessione.getSaltate()), "Saltate", "#f39c12"), this.creaStatCard("\ud83c\udfaf", String.format("%.0f%%", percentuale), "Precisione", "#3498db")});
        VBox riepilogoBox = this.creaRiepilogo();
        int posizione = this.app.getGestoreDati().getPosizione(this.app.getGiocatoreCorrente().getNickname());
        Label posLabel = new Label();
        if (posizione > 0) {
            posLabel.setText("\ud83d\udccd Sei al " + posizione + "\u00b0 posto in classifica");
            posLabel.getStyleClass().addAll((Object[])new String[]{"text-muted", "text-large"});
        }
        HBox buttonRow = new HBox(15.0);
        buttonRow.setAlignment(Pos.CENTER);
        Button btnNuovo = new Button("\ud83d\udd04 Nuovo Quiz");
        btnNuovo.getStyleClass().add((Object)"btn-primary");
        btnNuovo.setOnAction(e -> this.app.mostraQuiz());
        Button btnMenu = new Button("\ud83c\udfe0 Menu");
        btnMenu.getStyleClass().add((Object)"btn-secondary");
        btnMenu.setOnAction(e -> this.app.mostraMenu());
        buttonRow.getChildren().addAll((Object[])new Node[]{btnNuovo, btnMenu});
        container.getChildren().addAll((Object[])new Node[]{emojiLabel, titoloLabel, subtitleLabel, punteggioBox, statsRow, riepilogoBox, posLabel, buttonRow});
        scroll.setContent((Node)container);
        StackPane scrollWrapper = new StackPane(new Node[]{scroll});
        scrollWrapper.setAlignment(Pos.CENTER);
        root.getChildren().add((Object)scrollWrapper);
        this.animaEntrata(container);
        return root;
    }

    private VBox creaStatCard(String emoji, String valore, String etichetta, String colore) {
        VBox card = new VBox(5.0);
        card.setAlignment(Pos.CENTER);
        card.getStyleClass().add((Object)"stat-card");
        card.setMinWidth(100.0);
        Label emojiL = new Label(emoji);
        emojiL.setStyle("-fx-font-size: 22px;");
        Label valL = new Label(valore);
        valL.setStyle("-fx-font-size: 22px; -fx-font-weight: bold; -fx-text-fill: " + colore + ";");
        Label etL = new Label(etichetta);
        etL.getStyleClass().add((Object)"text-muted");
        etL.setStyle("-fx-font-size: 12px;");
        card.getChildren().addAll((Object[])new Node[]{emojiL, valL, etL});
        return card;
    }

    private VBox creaRiepilogo() {
        VBox box = new VBox(8.0);
        box.getStyleClass().add((Object)"card-light");
        box.setPadding(new Insets(15.0));
        Label titolo = new Label("Riepilogo domande");
        titolo.getStyleClass().addAll((Object[])new String[]{"text-white"});
        titolo.setStyle("-fx-font-size: 16px; -fx-font-weight: bold;");
        box.getChildren().add((Object)titolo);
        for (int i = 0; i < this.sessione.getDomande().size(); ++i) {
            String icon;
            Domanda d = this.sessione.getDomande().get(i);
            RisultatoRisposta r = this.sessione.getRisultati().get(i);
            int punti = this.sessione.getPuntiPerDomanda().get(i);
            String colore = switch (r) {
                case RisultatoRisposta.CORRETTA -> {
                    icon = "\u2705";
                    yield "#2ecc71";
                }
                case RisultatoRisposta.SBAGLIATA -> {
                    icon = "\u274c";
                    yield "#e74c3c";
                }
                case RisultatoRisposta.TEMPO_SCADUTO -> {
                    icon = "\u23f0";
                    yield "#e74c3c";
                }
                default -> {
                    icon = "\u23ed";
                    yield "#f39c12";
                }
            };
            HBox riga = new HBox(10.0);
            riga.setAlignment(Pos.CENTER_LEFT);
            Label numLabel = new Label(i + 1 + ".");
            numLabel.getStyleClass().add((Object)"text-muted");
            numLabel.setMinWidth(25.0);
            Label iconLabel = new Label(icon);
            iconLabel.setStyle("-fx-font-size: 16px;");
            Label nomeLabel = new Label(d.getNazioneCorretta().getNome());
            nomeLabel.getStyleClass().add((Object)"text-white");
            HBox.setHgrow((Node)nomeLabel, (Priority)Priority.ALWAYS);
            Label puntiLabel = new Label((String)(punti > 0 ? "+" + punti : "0"));
            puntiLabel.setStyle("-fx-font-weight: bold; -fx-text-fill: " + colore + ";");
            riga.getChildren().addAll((Object[])new Node[]{numLabel, iconLabel, nomeLabel, puntiLabel});
            box.getChildren().add((Object)riga);
        }
        return box;
    }

    private void animaEntrata(VBox container) {
        container.setOpacity(0.0);
        container.setTranslateY(30.0);
        FadeTransition fade = new FadeTransition(Duration.millis((double)600.0), (Node)container);
        fade.setToValue(1.0);
        TranslateTransition slide = new TranslateTransition(Duration.millis((double)600.0), (Node)container);
        slide.setToY(0.0);
        new ParallelTransition(new Animation[]{fade, slide}).play();
    }
}

