/*
 * Decompiled with CFR 0.152.
 */
package it.quizmaster.view;

import it.quizmaster.App;
import it.quizmaster.model.Giocatore;
import javafx.animation.FadeTransition;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class SchermataStatistiche {
    private final App app;

    public SchermataStatistiche(App app) {
        this.app = app;
    }

    public StackPane crea() {
        StackPane root = new StackPane();
        VBox container = new VBox(25.0);
        container.setAlignment(Pos.CENTER);
        container.setPadding(new Insets(30.0, 40.0, 30.0, 40.0));
        container.setMaxWidth(550.0);
        Giocatore g = this.app.getGiocatoreCorrente();
        Label titolo = new Label("\ud83d\udcca Le tue Statistiche");
        titolo.getStyleClass().add((Object)"section-title");
        titolo.setStyle("-fx-font-size: 30px;");
        Label nickname = new Label(g.getNickname());
        nickname.getStyleClass().addAll((Object[])new String[]{"text-accent", "text-large"});
        nickname.setStyle("-fx-font-weight: bold; -fx-font-size: 20px;");
        VBox punteggioCard = new VBox(5.0);
        punteggioCard.setAlignment(Pos.CENTER);
        punteggioCard.getStyleClass().add((Object)"card");
        punteggioCard.setPadding(new Insets(25.0));
        Label punteggioVal = new Label(String.valueOf(g.getPunteggioTotale()));
        punteggioVal.setStyle("-fx-font-size: 48px; -fx-font-weight: bold; -fx-text-fill: #e94560;");
        Label punteggioEtich = new Label("Punteggio Totale");
        punteggioEtich.getStyleClass().addAll((Object[])new String[]{"text-muted", "text-large"});
        punteggioCard.getChildren().addAll((Object[])new Node[]{punteggioVal, punteggioEtich});
        GridPane grid = new GridPane();
        grid.setHgap(15.0);
        grid.setVgap(15.0);
        grid.setAlignment(Pos.CENTER);
        grid.add((Node)this.creaStatTile("\ud83c\udfae", String.valueOf(g.getQuizCompletati()), "Quiz Completati", "#3498db"), 0, 0);
        grid.add((Node)this.creaStatTile("\u2705", String.valueOf(g.getRisposteCorrette()), "Risposte Corrette", "#2ecc71"), 1, 0);
        grid.add((Node)this.creaStatTile("\u274c", String.valueOf(g.getRisposteSbagliate()), "Risposte Sbagliate", "#e74c3c"), 0, 1);
        grid.add((Node)this.creaStatTile("\u23ed", String.valueOf(g.getRisposteSaltate()), "Risposte Saltate", "#f39c12"), 1, 1);
        VBox precisioneBox = this.creaPrecisioneBar(g);
        int pos = this.app.getGestoreDati().getPosizione(g.getNickname());
        Label posLabel = new Label();
        if (pos > 0) {
            String medaglia = pos == 1 ? "\ud83e\udd47" : (pos == 2 ? "\ud83e\udd48" : (pos == 3 ? "\ud83e\udd49" : "\ud83d\udccd"));
            posLabel.setText(medaglia + " " + pos + "\u00b0 in classifica");
            posLabel.getStyleClass().addAll((Object[])new String[]{"text-white", "text-large"});
            posLabel.setStyle("-fx-font-weight: bold; -fx-font-size: 18px;");
        }
        Button btnIndietro = new Button("\u2190 Torna al Menu");
        btnIndietro.getStyleClass().add((Object)"btn-secondary");
        btnIndietro.setOnAction(e -> this.app.mostraMenu());
        container.getChildren().addAll((Object[])new Node[]{titolo, nickname, punteggioCard, grid, precisioneBox, posLabel, btnIndietro});
        root.getChildren().add((Object)container);
        container.setOpacity(0.0);
        FadeTransition fade = new FadeTransition(Duration.millis((double)400.0), (Node)container);
        fade.setToValue(1.0);
        fade.play();
        return root;
    }

    private VBox creaStatTile(String emoji, String valore, String etichetta, String colore) {
        VBox tile = new VBox(5.0);
        tile.setAlignment(Pos.CENTER);
        tile.getStyleClass().add((Object)"stat-card");
        tile.setMinWidth(180.0);
        tile.setMinHeight(100.0);
        Label emojiL = new Label(emoji);
        emojiL.setStyle("-fx-font-size: 24px;");
        Label valL = new Label(valore);
        valL.setStyle("-fx-font-size: 26px; -fx-font-weight: bold; -fx-text-fill: " + colore + ";");
        Label etL = new Label(etichetta);
        etL.getStyleClass().add((Object)"text-muted");
        etL.setStyle("-fx-font-size: 13px;");
        tile.getChildren().addAll((Object[])new Node[]{emojiL, valL, etL});
        return tile;
    }

    private VBox creaPrecisioneBar(Giocatore g) {
        VBox box = new VBox(8.0);
        box.getStyleClass().add((Object)"card-light");
        box.setPadding(new Insets(15.0));
        double perc = g.getPercentualeCorrette();
        HBox header = new HBox();
        header.setAlignment(Pos.CENTER_LEFT);
        Label titolo = new Label("\ud83c\udfaf Precisione");
        titolo.getStyleClass().add((Object)"text-white");
        titolo.setStyle("-fx-font-weight: bold;");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        Label percLabel = new Label(String.format("%.1f%%", perc));
        percLabel.setStyle("-fx-font-weight: bold; -fx-font-size: 16px; -fx-text-fill: " + this.getColorePercentuale(perc) + ";");
        header.getChildren().addAll((Object[])new Node[]{titolo, spacer, percLabel});
        ProgressBar bar = new ProgressBar(perc / 100.0);
        bar.setMaxWidth(Double.MAX_VALUE);
        bar.setPrefHeight(12.0);
        bar.setStyle("-fx-accent: " + this.getColorePercentuale(perc) + ";");
        int totali = g.getRisposteTotali();
        Label dettaglio = new Label(g.getRisposteCorrette() + " corrette su " + totali + " totali");
        dettaglio.getStyleClass().add((Object)"text-muted");
        box.getChildren().addAll((Object[])new Node[]{header, bar, dettaglio});
        return box;
    }

    private String getColorePercentuale(double perc) {
        if (perc >= 80.0) {
            return "#2ecc71";
        }
        if (perc >= 60.0) {
            return "#3498db";
        }
        if (perc >= 40.0) {
            return "#f39c12";
        }
        return "#e74c3c";
    }
}

